#------------------------------------------------------------------------------
rm(list=ls()) #clear all
library(abind)
#require(rjags) 
#library(coda)
options(scipen = 8)

#####
# Define matrices to convert transducer <-> sonic coordinates for CSAT3
H_StoT = matrix(c(1/4,0.433012701892219,0.866025403784439,-1/2,0,0.866025403784439,1/4,-0.433012701892219,0.866025403784439),nrow=3,ncol=3)
G_TtoS = matrix(c(2/3,-4/3,2/3,1.154700538379252,0,-1.154700538379252,0.384900179459751,0.384900179459751,0.384900179459751),nrow=3,ncol=3)

#####
# Read in metadata
setwd("c:\\Studies\\2015\\Sonic Shadowing\\Symmetry\\Metadata\\")#
#setwd("/project/ARCC/jbaker2/bbtrees/jfrank5")
fname_in = sprintf('Metadata_1866.csv')
names = as.vector(read.table(fname_in,sep = ",",header = 1, nrows=1,na.strings = c(".","NAN")))
MetaData = as.data.frame(read.table(fname_in,sep = ",",skip=1,na.strings = c(".","NAN")))
colnames(MetaData) = colnames(names)
B = max(MetaData$TimeCode) # Number of 5-minutes
I = length(MetaData$DOY) # Number of 5-minute data files

#####
# Read in symmetry
setwd("c:\\Studies\\2015\\Sonic Shadowing\\Symmetry\\Metadata\\")#
#setwd("/project/ARCC/jbaker2/bbtrees/jfrank5")
fname_in = sprintf('Symmetry.csv')
SymData = as.data.frame(read.table(fname_in,sep = ",",skip=0,na.strings = c(".","NAN")))
colnames(SymData) = c("A1","A2", "A3", "A4", "B1","B2", "B3", "B4","C1", "C2", "C3", "C4")
L = nrow(SymData) # Number of 5-minutes
XX = array(NA,dim=c(L,4,3))
XX[,1,1] = SymData[,1]
XX[,2,1] = SymData[,2]
XX[,3,1] = SymData[,3]
XX[,4,1] = SymData[,4]
XX[,1,2] = SymData[,5]
XX[,2,2] = SymData[,6]
XX[,3,2] = SymData[,7]
XX[,4,2] = SymData[,8]
XX[,1,3] = SymData[,9]
XX[,2,3] = SymData[,10]
XX[,3,3] = SymData[,11]
XX[,4,3] = SymData[,12]

Ng = array(NA,dim=c(L))
for (l in 1:L) {
  Ng[l] =  sum(is.finite(XX[l,,1]))
}

#####
# Read in the Kaimal correction for each point around the geodesic grid
fname_in = sprintf('Priors.csv')
K = as.data.frame(read.table(fname_in,sep = ",",skip=0,na.strings = c(".","NAN"))) # Kaimal correction, prior for alpha
colnames(K) = c("Cu","Cv","Cw")
G = nrow(K) # Number of geodesic grid points

#####
# Read in time series data from each 5-minute data file
TSData <- list()
setwd("c:\\Studies\\2015\\Sonic Shadowing\\Symmetry\\Time series data\\")#

for (i in 1:I) {
  fname_in = sprintf('%04i%03i%04i_S%01i_P%01i.dat',MetaData$YEAR[i],MetaData$DOY[i],MetaData$HMIN[i],MetaData$Sonic[i],MetaData$Position[i])#
#  fname_in = sprintf('tsd/%04i%03i%04i_S%01i_P%01i.dat',MetaData$YEAR[i],MetaData$DOY[i],MetaData$HMIN[i],MetaData$Sonic[i],MetaData$Position[i])
  TSData[[i]] <-  as.data.frame(read.table(fname_in,sep = ",",skip=0,na.strings = c(".","NAN")))
}
J = nrow(TSData[[1]]) # Number of time series data in five minutes

#####
# Calculate the five minute standard deviation data, i.e., the primary data used in the model
s = t(matrix(apply(as.data.frame(TSData),2,sd),nrow=4)) # five minute standard deviation data
s = s[,-4]

#####
# time series data
u <- abind(lapply(TSData,"[",1),along=1)
v <- abind(lapply(TSData,"[",2),along=1)
w <- abind(lapply(TSData,"[",3),along=1)
GridPt <- abind(lapply(TSData,"[",4),along=1)
Orient = array(NA,dim=c(length(u),1))
for (i in 1:I) {
  Orient[((i-1)*J+1):(i*J)] = MetaData$ORIENT[i]
}
#####
# time series data in Cardinal coordinates
Uc = matrix(c(u,v,w),nrow = length(u)) # time series data in Cardinal coordinates
#####
# time series data in sonic coordinates
Us = Uc # time series data in sonic coordinates
id = Orient == 2
Us[id,2] = Uc[id,3]
Us[id,3] = -Uc[id,2]
#####
# Calculate the time series data in transducer coordinates, i.e., the secondary data used in the model
Ut = Us %*% H_StoT # time series data in transducer coordinates

#####
setwd("c:\\Studies\\2015\\Sonic Shadowing\\Symmetry\\Analysis\\")#
#dir = sprintf('c:\\Studies\\2015\\Sonic Shadowing\\Symmetry\\Analysis\\')#
dir = sprintf("./")

#####
# number of time series data in each geodesic grid point
h = hist(GridPt,0.5:1:(nrow(K)+0.5))
fname_out = paste(dir,"hist.csv",sep = "")
write.csv(h$counts,file=fname_out)

#####
# save the five minute standard deviation data, i.e., the primary data used in the model
fname_out = paste(dir,"s.csv",sep = "")
write.csv(t(s),file=fname_out)#,append=TRUE)
fname_out = paste(dir,"s.RData",sep = "")
save(s,file=fname_out)

#####
# constants for prior distributions
c1 = 1
c2 = sqrt(12)/(max(Uc)-min(Uc)) # 1/std of a uniform distribution, not that it really matters
c3 = min(Uc) #should this be min(s)?, not that it really matters  
c4 = max(Uc) #should this be max(s)?, not that it really matters  
c5 = 0.1 #Standard deviation of alpha

#####
# indexing matrix, matches each five-minute data file to each five-minute
E = MetaData$TimeCode
h2 = hist(MetaData$TimeCode,0.5:1:(B+0.5))
Ne = h2$count
e = matrix(0,B,max(Ne))
for (i in 1:B) {
  if (Ne[i] > 0) {
    e[i,1:Ne[i]] = which(MetaData$TimeCode == i)
  }
}

#####
# indexing matrix, matches each time series data to each geodesic grid point
# f and Nf, the locations of samples within each grid point 
Nf = h$count
f = matrix(0,G,max(Nf))
for (i in 1:G) {
  if (Nf[i] > 0) {
    f[i,1:Nf[i]] = which(GridPt == i)
  }
}



# L is number of unique/symmetrical grid points
# l is index for L


#####
# indexing matrix, matches each horizontal time series data to each geodesic grid point
# Used to convert sonic coordinates to Cardinal coordinates
# fH and NfH, the locations of horizontal samples within each grid point 
id = Orient == 2
hH = hist(GridPt[id],0.5:1:(nrow(K)+0.5))
NfH = hH$count
fH = matrix(0,G,max(NfH))
for (i in 1:G) {
  message(i)
  if (NfH[i] > 0) {
    fH[i,1:NfH[i]] = which(GridPt == i & Orient == 2)
  }
}

#####
# initialize times series data with Kaimal correction
Ut_init = Ut
for (d in 1:3){
  for (g in 1:G){
    Ut_init[f[g,1:Nf[g]],d] = K[g,d]*Ut[f[g,1:Nf[g]],d]
  }
}
Us_init = Ut_init %*% G_TtoS #Convert to u, v, w
Uc_init = Us_init
id = Orient == 2
Uc_init[id,2] = -Us_init[id,3]
Uc_init[id,3] = Us_init[id,2]
s_init = s
for (d in 1:3){
  for (i in 1:I){
    s_init[i,d] = sd(Uc_init[(J*(i-1)+1):(J*i),d])
  }
}

#####
# initialize five minute standard deviation data with Kaimal correction
s_bar_init = array(NA,dim=c(B,3))
for (b in 1:B){
  s_bar_init[b,] = colMeans(s_init[e[b,1:Ne[b]],]) #Initial includes Kaimal correction
}

#####
# initial standard deviation of the residuals to deviance of five minute data files from five minutes
epsilon_init = array(NA,dim=c(I,3))
for (i in 1:I){
  epsilon_init[i,] = s_init[i,] - s_bar_init[E[i],]
}

#####
# define Markov chain
N = 10000 # length of Markov chain

#####
# define and initialized state variables
s_bar = array(NA,dim=c(B,3,N))
s_bar[,,1] = s_bar_init

alpha = array(NA,dim=c(G,3,N))
alpha[,1,1] = K[,1]
alpha[,2,1] = K[,2]
alpha[,3,1] = K[,3]

epsilon = array(NA,dim=c(N))
epsilon[1] = sd(epsilon_init)


#####
# define and initialize useful derived variables
#beta_old = matrix(1,I,3)
beta_old = s_init/s #Initial includes Kaimal correction
beta_new = beta_old
E_s_bar = matrix(NA,I,3)
Uc_prime_old = Uc_init #Initial includes Kaimal correction
Uc_prime_new = Uc_prime_old
Us_prime_old = Us_init #Initial includes Kaimal correction
Us_prime_new = Us_prime_old
Ut_prime_old = Ut_init #Initial includes Kaimal correction
Ut_prime_new = Ut_prime_old

pred = array(NA,dim=c(I,3,N))
corr = array(NA,dim=c(I,3,N))
resid = array(NA,dim=c(I,3,N))
corr[,,1] = beta_old # correction applied to the data
pred[,,1] = E_s_bar/beta_old # predicted data
resid[,,1] = s - pred[,,1] # model residual

for (i in 1:I){
  E_s_bar[i,] = s_bar[E[i],,1] #Update outside of this function
}

#ones_t = array(1,dim=c(G,3))%*%H_StoT
#alpha_s_init = (ones_t*alpha[,,1]) %*% G_TtoS
#alpha_s = array(NA,dim=c(G,3,N))
#alpha_s[,,1] = alpha_s_init

#####
# define random walk parameters
s_bar_MH_sd = 0.04 #0.01 
alpha_MH_sd = 0.32 #0.005
epsilon_MH_sd = 0.00075 #0.0025
s_bar_MH_sd_mcmc = array(NA,dim=c(N))
alpha_MH_sd_mcmc = array(NA,dim=c(N))
epsilon_MH_sd_mcmc = array(NA,dim=c(N))
s_bar_MH_sd_mcmc[1] = s_bar_MH_sd
alpha_MH_sd_mcmc[1] = alpha_MH_sd
epsilon_MH_sd_mcmc[1] = epsilon_MH_sd

s_bar_accept = array(NA,dim=c(B,3,N))
alpha_accept = array(NA,dim=c(G,3,N))
epsilon_accept = array(NA,dim=c(N))
s_bar_accept[,,1] = 1
alpha_accept[,,1] = 1
epsilon_accept[1] = 1

#####
# remove unneccessary variables before starting chain
rm(u) #
rm(v) #
rm(w) #
rm(names) #
rm(TSData) #
rm(h)
rm(h2)
rm(GridPt) #
rm(MetaData) #

##################################################
# Probability functions for the state variables

# log(Conditional probability for s_bar)
# assumes that beta_old (which is f(alpha)) and epsilon have been updated
p_s_bar = function (s_bar,epsilon,b,d){
  val = -1/(2*epsilon^2)*sum( (s[e[b,1:Ne[b]],d]-s_bar/beta_old[e[b,1:Ne[b]],d])^2 )
  return (val)
}
#debug(p_s_bar)

# log(Conditional probability for alpha)
# assumes that E_s_bar (which is f(s_bar)), and epsilon have been updated. beta is a f(alpha)
p_alpha = function (alpha,beta,epsilon,g,t){
  val = -1/(2*epsilon^2)*sum( (s-E_s_bar/beta)^2 ) - 1/(2*c5^2)*(alpha-K[g,t])^2
#  mu = (E_s_bar[,]/beta[,])
#  val = sum(dnorm(s[,],mean=mu,sd=epsilon,log=TRUE)) + dnorm(alpha,mean=K[g,t], sd=c5,log=TRUE)
  return (val)
}
#debug(p_alpha)

# log(Conditional probability for epsilon)
# assumes that beta_old (which is f(alpha)), and E_s_bar (which is f(s_bar)) have been updated
p_epsilon = function(epsilon){
  val = (c1 - 3*I - 1)*log(epsilon) + -1/(2*epsilon^2)*sum((s-E_s_bar/beta_old)^2)
  return (val)
}
#debug(p_epsilon)

##################################################
# Start chain
start.time = Sys.time()
#main = function(){
for (n in 2:N){ # MCMC steps
    message(n)

  #Gibbs sample s_bar
  for (d in 1:3){ # 3-Dimensions
#    message(d)
    for (b in 1:B){
#      message(b)
      # Metropolis-Hastings algorithm for s_bar
      s_bar_star = rgamma(1,shape=(s_bar[b,d,(n-1)]/s_bar_MH_sd)^2, rate=s_bar[b,d,(n-1)]/(s_bar_MH_sd)^2)
      R = exp( p_s_bar(s_bar_star,epsilon[(n-1)],b,d)
              -p_s_bar(s_bar[b,d,(n-1)],epsilon[(n-1)],b,d)
              +log(dgamma(s_bar[b,d,(n-1)],shape=(s_bar_star/s_bar_MH_sd)^2, rate=s_bar_star/(s_bar_MH_sd)^2))
              -log(dgamma(s_bar_star,shape=(s_bar[b,d,(n-1)]/s_bar_MH_sd)^2, rate=s_bar[b,d,(n-1)]/(s_bar_MH_sd)^2))
              )
      if (runif(1) < min(R,1)){
        s_bar[b,d,n] = s_bar_star
        s_bar_accept[b,d,n] = 1
      }
      else {
        s_bar[b,d,n] = s_bar[b,d,(n-1)]
        s_bar_accept[b,d,n] = 0
      }
    }
    
    #Update E*s_bar matrix
    for (i in 1:I){
      E_s_bar[i,] = s_bar[E[i],,n] #Update outside of this function
    }
  }

  #Gibbs sample alpha
  for (l in 1:L){ # unique/symmetric
#    message(t)
#browser()
      # Metropolis-Hastings algorithm for alpha
      alpha_star = rnorm(1,mean=alpha[XX[l,1,1],1,(n-1)],sd=alpha_MH_sd) #normal proposal distribution

      #note, this indexing is slightly redundant. I estimate it to redo about 8.3% too many
      for (t in 1:3){ # 3-Dimensions of transducers
        for (gg in 1:Ng[l]) {
          g = XX[l,gg,t] # XX is list that links L to g 
          Ut_prime_new[f[g,1:Nf[g]],t] = alpha_star*Ut[f[g,1:Nf[g]],t]
          Us_prime_new[f[g,1:Nf[g]],] = Ut_prime_new[f[g,1:Nf[g]],] %*% G_TtoS #Convert to u, v, w
          Uc_prime_new[fH[g,1:NfH[g]],1] = Us_prime_new[fH[g,1:NfH[g]],1] #The horizontal mounted need to be rotated around the u-axis
          Uc_prime_new[fH[g,1:NfH[g]],2] = -Us_prime_new[fH[g,1:NfH[g]],3] #The horizontal mounted need to be rotated around the u-axis
          Uc_prime_new[fH[g,1:NfH[g]],3] = Us_prime_new[fH[g,1:NfH[g]],2] #The horizontal mounted need to be rotated around the u-axis
        }
      }

      for (i in 1:I){
        for (d in 1:3){
          beta_new[i,d] = sd(Uc_prime_new[(J*(i-1)+1):(J*i),d])/s[i,d]
        }
      }
      R = exp(p_alpha(alpha_star,beta_new,epsilon[(n-1)],XX[l,1,1],1)-p_alpha(alpha[XX[l,1,1],1,(n-1)],beta_old,epsilon[(n-1)],XX[l,1,1],1))
      if (runif(1) < min(R,1)) {
        for (t in 1:3) { # 3-Dimensions of transducers
          for (gg in 1:Ng[l]) {
            g = XX[l,gg,t] # XX is list that links L to g 
            alpha[g,t,n] = alpha_star
            alpha_accept[g,t,n] = 1
            Uc_prime_old[f[g,1:Nf[g]],] = Uc_prime_new[f[g,1:Nf[g]],]
            Us_prime_old[f[g,1:Nf[g]],] = Us_prime_new[f[g,1:Nf[g]],]
            Ut_prime_old[f[g,1:Nf[g]],t] = Ut_prime_new[f[g,1:Nf[g]],t]
          }
        }
        beta_old = beta_new
       }
      else {
        for (t in 1:3) { # 3-Dimensions of transducers
          for (gg in 1:Ng[l]) {
            g = XX[l,gg,t] # XX is list that links L to g 
            alpha[g,t,n] = alpha[g,t,(n-1)]
            alpha_accept[g,t,n] = 0
            Uc_prime_new[f[g,1:Nf[g]],] = Uc_prime_old[f[g,1:Nf[g]],]
            Us_prime_new[f[g,1:Nf[g]],] = Us_prime_old[f[g,1:Nf[g]],]
            Ut_prime_new[f[g,1:Nf[g]],t] = Ut_prime_old[f[g,1:Nf[g]],t]
          }
        }
        beta_new = beta_old
      }
  }
 
  #Gibbs sample epsilon
  # Metropolis-Hastings algorithm for epsilon
  epsilon_star = rgamma(1,shape=(epsilon[(n-1)]/epsilon_MH_sd)^2, rate=epsilon[(n-1)]/(epsilon_MH_sd)^2) #gamma proposal distribution
  R = exp( p_epsilon(epsilon_star)
          -p_epsilon(epsilon[(n-1)])
          +log(dgamma(epsilon[(n-1)],shape=(epsilon_star/epsilon_MH_sd)^2, rate=epsilon_star/(epsilon_MH_sd)^2))
          -log(dgamma(epsilon_star,shape=(epsilon[(n-1)]/epsilon_MH_sd)^2, rate=epsilon[(n-1)]/(epsilon_MH_sd)^2))
        )
  if (runif(1) < min(R,1)){
    epsilon[n] = epsilon_star
    epsilon_accept[n] = 1
  }
  else {
    epsilon[n] = epsilon[(n-1)]
    epsilon_accept[n] = 0
  }

  #####
  # finalize the correction, prediction, and residutal
#  alpha_s[,,n] = (ones_t*alpha[,,n]) %*% G_TtoS
  corr[,,n] = beta_old
  pred[,,n] = E_s_bar/beta_old
  resid[,,n] = s - pred[,,n]

  s_bar_MH_sd_mcmc[n] = s_bar_MH_sd
  alpha_MH_sd_mcmc[n] = alpha_MH_sd
  epsilon_MH_sd_mcmc[n] = epsilon_MH_sd

  #####
  # periodically update the proposal distributions to achieve optimal acceptance
  m = 25
  if (n %% m == 0){
    if (mean(epsilon_accept[(n-m+1):n]) > .5){    
      epsilon_MH_sd = 2*epsilon_MH_sd
    }
    if (mean(epsilon_accept[(n-m+1):n]) < .25){    
      epsilon_MH_sd = epsilon_MH_sd/2
    }
  }
  m = 10
  if (n %% m == 0){
    if (mean(s_bar_accept[,,(n-m+1):n]) > .5){    
        s_bar_MH_sd = 2*s_bar_MH_sd
    }
    if (mean(s_bar_accept[,,(n-m+1):n]) < .25){    
      s_bar_MH_sd = s_bar_MH_sd/2
    }
    if (mean(alpha_accept[,,(n-m+1):n]) > .5){    
      alpha_MH_sd = 2*alpha_MH_sd
    }
    if (mean(alpha_accept[,,(n-m+1):n]) < .25){    
      alpha_MH_sd = alpha_MH_sd/2
    }
  }

  #####
  # periodically output data
  m = 32
  if (n %% m == 0){
    fname_out = paste(dir,"alpha.a.csv",sep = "")
    write.csv(t(alpha[,1,]),file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"alpha.b.csv",sep = "")
    write.csv(t(alpha[,2,]),file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"alpha.c.csv",sep = "")
    write.csv(t(alpha[,3,]),file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"alpha.RData",sep = "")
    save(alpha,file=fname_out)
    
#    fname_out = paste(dir,"alpha_s.u.csv",sep = "")
#    write.csv(t(alpha_s[,1,]),file=fname_out)#,append=TRUE)
#    fname_out = paste(dir,"alpha_s.v.csv",sep = "")
#    write.csv(t(alpha_s[,2,]),file=fname_out)#,append=TRUE)
#    fname_out = paste(dir,"alpha_s.w.csv",sep = "")
#    write.csv(t(alpha_s[,3,]),file=fname_out)#,append=TRUE)
#    fname_out = paste(dir,"alpha_s.RData",sep = "")
#    save(alpha_s,file=fname_out)

    fname_out = paste(dir,"s_bar.u.csv",sep = "")
    write.csv(t(s_bar[,1,]),file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"s_bar.v.csv",sep = "")
    write.csv(t(s_bar[,2,]),file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"s_bar.w.csv",sep = "")
    write.csv(t(s_bar[,3,]),file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"s_bar.RData",sep = "")
    save(s_bar,file=fname_out)
    
    fname_out = paste(dir,"epsilon.csv",sep = "")
    write.csv(epsilon,file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"epsilon.RData",sep = "")
    save(epsilon,file=fname_out)
    
    fname_out = paste(dir,"pred.u.csv",sep = "")
    write.csv(t(pred[,1,]),file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"pred.v.csv",sep = "")
    write.csv(t(pred[,2,]),file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"pred.w.csv",sep = "")
    write.csv(t(pred[,3,]),file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"pred.RData",sep = "")
    save(pred,file=fname_out)
    
    fname_out = paste(dir,"corr.u.csv",sep = "")
    write.csv(t(corr[,1,]),file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"corr.v.csv",sep = "")
    write.csv(t(corr[,2,]),file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"corr.w.csv",sep = "")
    write.csv(t(corr[,3,]),file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"corr.RData",sep = "")
    save(corr,file=fname_out)
    
    fname_out = paste(dir,"resid.u.csv",sep = "")
    write.csv(t(resid[,1,]),file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"resid.v.csv",sep = "")
    write.csv(t(resid[,2,]),file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"resid.w.csv",sep = "")
    write.csv(t(resid[,3,]),file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"resid.RData",sep = "")
    save(resid,file=fname_out)

    fname_out = paste(dir,"alpha_accept.a.csv",sep = "")
    write.csv(t(alpha_accept[,1,]),file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"alpha_accept.b.csv",sep = "")
    write.csv(t(alpha_accept[,2,]),file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"alpha_accept.c.csv",sep = "")
    write.csv(t(alpha_accept[,3,]),file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"alpha_accept.RData",sep = "")
    save(alpha_accept,file=fname_out)
    
    fname_out = paste(dir,"s_bar_accept.u.csv",sep = "")
    write.csv(t(s_bar_accept[,1,]),file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"s_bar_accept.v.csv",sep = "")
    write.csv(t(s_bar_accept[,2,]),file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"s_bar_accept.w.csv",sep = "")
    write.csv(t(s_bar_accept[,3,]),file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"s_bar_accept.RData",sep = "")
    save(s_bar_accept,file=fname_out)
    
    fname_out = paste(dir,"epsilon_accept.csv",sep = "")
    write.csv(epsilon_accept,file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"epsilon_accept.RData",sep = "")
    save(epsilon_accept,file=fname_out)

    fname_out = paste(dir,"s_bar_MH_sd_mcmc.csv",sep = "")
    write.csv(s_bar_MH_sd_mcmc,file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"s_bar_MH_sd_mcmc.RData",sep = "")
    save(s_bar_MH_sd_mcmc,file=fname_out)
    
    fname_out = paste(dir,"alpha_MH_sd_mcmc.csv",sep = "")
    write.csv(alpha_MH_sd_mcmc,file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"alpha_MH_sd_mcmc.RData",sep = "")
    save(alpha_MH_sd_mcmc,file=fname_out)
  
    fname_out = paste(dir,"epsilon_MH_sd_mcmc.csv",sep = "")
    write.csv(epsilon_MH_sd_mcmc,file=fname_out)#,append=TRUE)
    fname_out = paste(dir,"epsilon_MH_sd_mcmc.RData",sep = "")
    save(epsilon_MH_sd_mcmc,file=fname_out)
  
  }
}
#return
#}
#debug(main)
#main()
end.time = Sys.time()
MCMC.time = end.time - start.time


#####
# if chain needs to be restarted, read in last output
dir = sprintf('c:\\Studies\\2015\\Sonic Shadowing\\Symmetry\\Analysis\\')#
 setwd(dir)
 load("alpha.RData")
#load("alpha_s.RData")
load("s_bar.RData")
 load("epsilon.RData")
 load("pred.RData")
 load("corr.RData")
 load("resid.RData")
 load("alpha_accept.RData")
 load("s_bar_accept.RData")
 load("epsilon_accept.RData")
 load("s_bar_MH_sd_mcmc.RData")
 load("alpha_MH_sd_mcmc.RData")
 load("epsilon_MH_sd_mcmc.RData")

